%------------------------------------------------------------------------------
% File     : NUM712^1 : TPTP v7.4.0. Released v3.7.0.
% Domain   : Number Theory
% Problem  : Landau theorem 31
% Version  : Especial.
% English  : ts (ts x y) z = ts x (ts y z)

% Refs     : [Lan30] Landau (1930), Grundlagen der Analysis
%          : [vBJ79] van Benthem Jutting (1979), Checking Landau's "Grundla
%          : [Bro09] Brown (2009), Email to Geoff Sutcliffe
% Source   : [Bro09]
% Names    : satz31 [Lan30]

% Status   : Theorem
%          : Without extensionality : Theorem
% Rating   : 1.00 v3.7.0
% Syntax   : Number of formulae    :   20 (   0 unit;  11 type;   0 defn)
%            Number of atoms       :   79 (   6 equality;  36 variable)
%            Maximal formula depth :    9 (   5 average)
%            Number of connectives :   58 (   0   ~;   0   |;   0   &;  53   @)
%                                         (   0 <=>;   5  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :   11 (  11   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   13 (  11   :;   0   =)
%            Number of variables   :   16 (   0 sgn;  16   !;   0   ?;   0   ^)
%                                         (  16   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : 
%------------------------------------------------------------------------------
thf(nat_type,type,(
    nat: $tType )).

thf(x,type,(
    x: nat )).

thf(y,type,(
    y: nat )).

thf(z,type,(
    z: nat )).

thf(ts,type,(
    ts: nat > nat > nat )).

thf(set_type,type,(
    set: $tType )).

thf(esti,type,(
    esti: nat > set > $o )).

thf(setof,type,(
    setof: ( nat > $o ) > set )).

thf(estie,axiom,(
    ! [Xp: nat > $o,Xs: nat] :
      ( ( esti @ Xs @ ( setof @ Xp ) )
     => ( Xp @ Xs ) ) )).

thf(n_1,type,(
    n_1: nat )).

thf(suc,type,(
    suc: nat > nat )).

thf(ax5,axiom,(
    ! [Xs: set] :
      ( ( esti @ n_1 @ Xs )
     => ( ! [Xx: nat] :
            ( ( esti @ Xx @ Xs )
           => ( esti @ ( suc @ Xx ) @ Xs ) )
       => ! [Xx: nat] :
            ( esti @ Xx @ Xs ) ) ) )).

thf(estii,axiom,(
    ! [Xp: nat > $o,Xs: nat] :
      ( ( Xp @ Xs )
     => ( esti @ Xs @ ( setof @ Xp ) ) ) )).

thf(satz28e,axiom,(
    ! [Xx: nat] :
      ( Xx
      = ( ts @ Xx @ n_1 ) ) )).

thf(satz28a,axiom,(
    ! [Xx: nat] :
      ( ( ts @ Xx @ n_1 )
      = Xx ) )).

thf(pl,type,(
    pl: nat > nat > nat )).

thf(satz28f,axiom,(
    ! [Xx: nat,Xy: nat] :
      ( ( pl @ ( ts @ Xx @ Xy ) @ Xx )
      = ( ts @ Xx @ ( suc @ Xy ) ) ) )).

thf(satz30,axiom,(
    ! [Xx: nat,Xy: nat,Xz: nat] :
      ( ( ts @ Xx @ ( pl @ Xy @ Xz ) )
      = ( pl @ ( ts @ Xx @ Xy ) @ ( ts @ Xx @ Xz ) ) ) )).

thf(satz28b,axiom,(
    ! [Xx: nat,Xy: nat] :
      ( ( ts @ Xx @ ( suc @ Xy ) )
      = ( pl @ ( ts @ Xx @ Xy ) @ Xx ) ) )).

thf(satz31,conjecture,
    ( ( ts @ ( ts @ x @ y ) @ z )
    = ( ts @ x @ ( ts @ y @ z ) ) )).

%------------------------------------------------------------------------------
